/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageLineRTF;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IONameSettingPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    protected LogoDisplay fLogoDisplay;
    protected IONameDisplayElement fIODisplayElement;
    protected WiringDiagram fWD;
    protected int fCharSet;
    protected LogoDisplay fOnNameDisplay;
    protected LogoDisplay fOffNameDisplay;
    protected IONameLine fOnLine;
    protected IONameLine fOffLine;
    private JComboBox fcmbType;
    private JComboBox fcmbBlockNumber;
    private static Object[][] fTypeList;

    public IONameSettingPanel(LogoDisplay display, IONameDisplayElement disp, WiringDiagram wd) {
        this.fLogoDisplay = display;
        this.fIODisplayElement = disp;
        this.fWD = wd;
        this.fCharSet = ((MutiCharSetDisplayModel)((Object)display.getModel())).getCharSet();
        this.initialize();
    }

    private void initialize() {
        this.setName(Language.getString("dialog.parameter.message.setIOTitle", "IO status name"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getIOPanel(), "North");
        this.add((Component)this.getNameInputPanel(), "South");
        this.fOnNameDisplay.setDropEnabled(true);
        this.fOnNameDisplay.setDragEnabled(true);
        this.fOffNameDisplay.setDropEnabled(true);
        this.fOffNameDisplay.setDragEnabled(true);
    }

    private JPanel getIOPanel() {
        BorderJPanel ret = new BorderJPanel();
        ret.setTitle(Language.getString("dialog.parameter.message.setIO", "I/O Setting"));
        ret.setLayout(new GridBagLayout());
        JLabel lblType = new JLabel(Language.getString("dialog.parameter.message.setIOType", "Select I/O type"));
        JLabel lblNumber = new JLabel(Language.getString("dialog.parameter.message.setIO_ID", "Select I/O"));
        this.fcmbType = new JComboBox();
        this.fcmbType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IONameSettingPanel.this.refreshBlockNumberList();
            }
        });
        this.fcmbBlockNumber = new JComboBox();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        ret.add((Component)lblType, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ret.add((Component)this.fcmbType, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        ret.add((Component)lblNumber, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ret.add((Component)this.fcmbBlockNumber, gbc);
        return ret;
    }

    private JPanel getNameInputPanel() {
        BorderJPanel ret = new BorderJPanel();
        ret.setTitle(Language.getString("dialog.parameter.message.setIOString", "Input status name"));
        ret.setLayout(new GridBagLayout());
        JLabel lblFalse = new JLabel(Language.getString("dialog.parameter.message.setIOStringFalse", "Input name for status FALSE"));
        JLabel lblTrue = new JLabel(Language.getString("dialog.parameter.message.setIOStringTrue", "Input name for status TRUE"));
        this.fOffNameDisplay = new LogoDisplay();
        this.fOnNameDisplay = new LogoDisplay();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        ret.add((Component)lblFalse, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ret.add((Component)this.fOffNameDisplay, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        ret.add((Component)lblTrue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ret.add((Component)this.fOnNameDisplay, gbc);
        return ret;
    }

    public void loadFieldContents() throws ProgramException {
        this.fcmbType.setModel(new DefaultComboBoxModel<Object>(IONameSettingPanel.getTypeList()[1]));
        int blockType = this.fIODisplayElement.getType();
        if (blockType != -1) {
            this.fcmbType.setSelectedIndex(IONameSettingPanel.getIndexOfList(blockType));
            this.refreshBlockNumberList();
            if (blockType == 0) {
                this.fcmbBlockNumber.setSelectedItem(this.fIODisplayElement.getBlock().getLocalizedName(true));
            } else {
                this.fcmbBlockNumber.setSelectedItem(this.fIODisplayElement.getBlock().getNumberString());
            }
        } else {
            this.refreshBlockNumberList();
        }
        this.fOffLine = new IONameLine(this.fCharSet);
        this.fOnLine = new IONameLine(this.fCharSet);
        if (this.fIODisplayElement.getCharSet() == this.fCharSet) {
            this.fOffLine.setNameBytes(this.fIODisplayElement.getNameBytes(0));
            this.fOnLine.setNameBytes(this.fIODisplayElement.getNameBytes(1));
        }
        this.fOffNameDisplay.setModel(new IONameModel(this.fOffLine, this.fCharSet));
        this.fOffNameDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
        this.fOnNameDisplay.setModel(new IONameModel(this.fOnLine, this.fCharSet));
        this.fOnNameDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
    }

    private void refreshBlockNumberList() {
        Object[] ioList = this.getBlockList(this.getSelectedBlockType());
        this.fcmbBlockNumber.setModel(new DefaultComboBoxModel<Object>(ioList));
    }

    private static Object[][] getTypeList() {
        if (fTypeList == null) {
            fTypeList = new Object[][]{{6, 7, 10, 17, 21, 19, 0}, {Language.getString("hardware.DigitalInput", "Digital inputs"), Language.getString("hardware.DigitalOutput", "Digital outputs"), Language.getString("hardware.Marker", "Flag"), Language.getString("hardware.KeyInput", "Cursor key"), Language.getString("block.TDFunctionKeyInput", "TD function key"), Language.getString("block.ShiftRegisterInput", "Shift register bit"), Language.getString("block.this.output", "Function block output")}};
        }
        return fTypeList;
    }

    private static int getIndexOfList(int blockType) {
        for (int i = 0; i < IONameSettingPanel.getTypeList()[0].length; ++i) {
            if ((Integer)IONameSettingPanel.getTypeList()[0][i] != blockType) continue;
            return i;
        }
        return -1;
    }

    private int getSelectedBlockType() {
        return (Integer)IONameSettingPanel.getTypeList()[0][this.fcmbType.getSelectedIndex()];
    }

    public boolean checkFieldContents() {
        if (this.fcmbType.getSelectedIndex() == -1 || this.fcmbBlockNumber.getSelectedIndex() == -1) {
            new LogoError(this, "dialog.parameter.message.setIOError", "Invalid Setting, check I/O type and blockNumber.").display();
            return false;
        }
        return super.checkFieldContents();
    }

    public void storeFieldContents() {
        this.fIODisplayElement.setType(this.getSelectedBlockType());
        this.fIODisplayElement.setCharSet(this.fCharSet);
        try {
            int blockNumber;
            if (this.getSelectedBlockType() == 0) {
                blockNumber = Integer.parseInt(((String)this.fcmbBlockNumber.getSelectedItem()).substring(1, 4));
            } else if (this.getSelectedBlockType() == 17) {
                blockNumber = Integer.parseInt(((String)this.fcmbBlockNumber.getSelectedItem()).substring(1, 2));
            } else if (this.getSelectedBlockType() == 19) {
                blockNumber = (Integer.parseInt(((String)this.fcmbBlockNumber.getSelectedItem()).substring(1, 2)) - 1) * 8;
                blockNumber += Integer.parseInt(((String)this.fcmbBlockNumber.getSelectedItem()).substring(3, 4));
            } else {
                blockNumber = Integer.parseInt(((String)this.fcmbBlockNumber.getSelectedItem()).substring(1));
            }
            this.fIODisplayElement.setNumber(blockNumber);
        }
        catch (Exception e) {
            this.fIODisplayElement.setNumber(-1);
        }
        IONameModel offModel = (IONameModel)this.fOffNameDisplay.getModel();
        this.saveModelToLine(offModel, this.fOffLine);
        IONameModel onModel = (IONameModel)this.fOnNameDisplay.getModel();
        this.saveModelToLine(onModel, this.fOnLine);
        int[] nameBytes0 = this.fOffLine.getNameBytes();
        this.fIODisplayElement.setNameByte(0, nameBytes0);
        int[] nameBytes1 = this.fOnLine.getNameBytes();
        this.fIODisplayElement.setNameByte(1, nameBytes1);
    }

    private void saveModelToLine(IONameModel model, IONameLine line) {
        int x = 0;
        while (x < line.getLineWidth()) {
            DisplayElement displayElement = model.getElementAt(new Point(x, 0));
            line.setDisplayElement((DefaultDisplayElement)displayElement, x);
            if (displayElement != null) {
                x += displayElement.getWidth();
                continue;
            }
            ++x;
        }
    }

    private Object[] getBlockList(int blockType) {
        Object[] ret = null;
        ret = blockType >= 0 ? this.fWD.getBlockNumberList(blockType, 1) : new Object[]{};
        return ret;
    }

    protected static class IONameLine {
        MessageLineRTF fMessageLineRTF;

        public IONameLine(int charSet) {
            this.fMessageLineRTF = new MessageLineRTF(null, 0, charSet){
                private static final long serialVersionUID = 1L;

                public int getLineWidth() {
                    return 8;
                }
            };
        }

        public int getLineWidth() {
            return 8;
        }

        public void setDisplayElement(DefaultDisplayElement displayElement, int position) {
            this.fMessageLineRTF.setDisplayElement(displayElement, position);
        }

        public DefaultDisplayElement getDisplayElement(int position) {
            DisplayElement ret = this.fMessageLineRTF.getDisplayElement(position);
            if (ret instanceof DefaultDisplayElement) {
                return (DefaultDisplayElement)ret;
            }
            return new DefaultDisplayElement(" ", 1, 1);
        }

        public int[] getNameBytes() {
            int[] contentBytes = new int[this.getLineWidth()];
            System.arraycopy(this.fMessageLineRTF.getContentsBytes(), 0, contentBytes, 0, contentBytes.length);
            return contentBytes;
        }

        public void setNameBytes(int[] nameBytes) {
            System.arraycopy(nameBytes, 0, this.fMessageLineRTF.getContentsBytes(), 0, Math.min(nameBytes.length, 8));
        }
    }

    protected static class IONameModel
    extends RectangleElementsDisplayModel {
        protected IONameLine fIONameLine;

        public IONameModel(IONameLine line, int charSet) {
            super(new Dimension(0, 0), charSet);
            this.fIONameLine = line;
            this.setElements();
        }

        private void setElements() {
            this.setDisplayDimension();
            this.updateDisplayElement();
        }

        private void setDisplayDimension() {
            this.setDisplayDimension(new Dimension(this.fIONameLine.getLineWidth(), 1));
        }

        public void updateDisplayElement() {
            this.fDisplayElements = new DisplayElement[this.fDisplayDimension.width][this.fDisplayDimension.height];
            DefaultDisplayElement displayElement = null;
            for (int i = 0; i < this.fDisplayDimension.width; i += displayElement.getWidth()) {
                displayElement = this.fIONameLine.getDisplayElement(i);
                this.setElementAt(displayElement, new Point(i, 0));
            }
        }

        public boolean isCellEditable(Point location) {
            return true;
        }
    }
}

